local t = Def.ActorFrame {};

local playMode = GAMESTATE:GetPlayMode()

local sStage = ""
sStage = GAMESTATE:GetCurrentStage()

if playMode ~= 'PlayMode_Regular' and playMode ~= 'PlayMode_Rave' and playMode ~= 'PlayMode_Battle' then
  sStage = playMode;
end;

if not (GAMESTATE:IsCourseMode() or GAMESTATE:IsExtraStage() or GAMESTATE:IsExtraStage2()) then
        local tRemap = {
                Stage_Event             = 0,
                Stage_1st               = 1,
                Stage_2nd               = 2,
                Stage_3rd               = 3,
                Stage_4th               = 4,
                Stage_5th               = 5,
                Stage_6th               = 6,
                Stage_Final               = 7,
                Stage_Extra1               = 8,
                Stage_Extra2              = 9,
        };

        local nSongCount = tRemap[sStage] + (GAMESTATE:GetCurrentSong():GetStageCost()-1);

        if nSongCount >= PREFSMAN:GetPreference("SongsPerPlay") then
        sStage = "Stage_Final";
        else
                sStage = sStage;
        end;
end;

local t = Def.ActorFrame {};
local course = GAMESTATE:GetCurrentCourse();
local cname = course:GetDisplayFullTitle();
local cbn = course:GetBannerPath();
local ctype = course:GetCourseType()

t[#t+1] = Def.ActorFrame { -- zooming tv w/ static
	LoadActor("_tvscreen")..{
		InitCommand=function(self) self:zoom(1):zoomx(0.7):diffuse(color("#FF0000")) end;
	};
	LoadActor("_static")..{
		InitCommand=function(self) self:zoom(0.375):zoomx(0.3825):queuecommand("Play") end;
		OnCommand=function(self) self:sleep(2.5):linear(0.75):diffusealpha(0.4) end;
		PlayCommand=function(self) self:play() end;
	};
	InitCommand=function(self) self:Center() end;
	OnCommand=function(self) self:linear(3):zoom(1.8) end;
};
-- decorate the static!
t[#t+1] = LoadActor( THEME:GetPathG("ScreenStageInformation", "Stage " .. ToEnumShortString(ctype) ) ) .. {
	InitCommand=function(self) self:Center():addy(200):zoom(0.6):diffusealpha(0) end;
	OnCommand=function(self) self:sleep(3):decelerate(2):addy(-50):diffusealpha(1) end;
};
t[#t+1] = Def.BitmapText{
	Font="_coaster";
	InitCommand=function(self) self:settext(cname):strokecolor(color("#000000")):Center():addy(75):diffusealpha(0) end;
	OnCommand=function(self) self:sleep(3.25):linear(1):diffusealpha(1) end;
};
if course:HasBanner() then
	t[#t+1] = LoadActor(cbn)..{
			InitCommand=function(self) self:Center():addy(-50):diffusealpha(0) end;
			OnCommand=function(self) self:sleep(3):decelerate(1):diffusealpha(1):zoom(0.4) end;
	};
else
	t[#t+1] = LoadActor(THEME:GetPathG("", "Common fallback jacket"))..{
			InitCommand=function(self) self:Center():addy(-50):diffusealpha(0) end;
			OnCommand=function(self) self:sleep(3):decelerate(1):diffusealpha(1):zoom(0.4) end;
	};
end
t[#t+1] = Def.ActorFrame { -- flash white
  Def.Quad {
    InitCommand=cmd(zoomto,SCREEN_WIDTH,SCREEN_HEIGHT;x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y;diffuse,color("#FFFFFF"));
    OnCommand=cmd(diffusealpha,1;sleep,0.1;decelerate,0.8;diffusealpha,0;);
  };
};

-- exit maneuver
t[#t+1] = Def.ActorFrame {
		Def.Quad {
			InitCommand=cmd(zoomto,SCREEN_WIDTH,SCREEN_HEIGHT;x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y;diffuse,color("#000000"));
			OnCommand=cmd(diffusealpha,0;sleep,6.9;smooth,0.6;diffusealpha,1;sleep,1;);
		};
		LoadActor(THEME:GetPathG("_transition", "emblem")) .. {
				InitCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y);
				OnCommand=cmd(rotationz,60;diffusealpha,0;sleep,6.9;zoom,0.3;smooth,0.6;rotationz,0;zoom,1;diffusealpha,1;);
		};
	};

t[#t+1] = LoadActor("_coursesound.ogg") .. {
        OnCommand=function(self) self:queuecommand("Play") end;
		PlayCommand=function(self) self:play() end;
};

return t;
